#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//Orange And TealMod01.fsh   by  zackpudil
//https://www.shadertoy.com/view/ts2XDt
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.177  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

mat2 rot(float a) {
    float s = sin(a);
    float c = cos(a);
    
    return mat2(c, s, -s, c);
}

float box(vec3 p, vec3 b) {
    vec3 q = abs(p) - b;
    return max(max(q.x, q.y), q.z);
}

vec2 shape(vec3 p) {
    float a = box(p, vec3(1));
    
	p = abs(p) - vec3(1);
    float b = box(p + vec3(1, 0, 0), vec3(1.200,0.200,0.200));
    float c = box(p + vec3(0, 0, 1), vec3(0.2, 0.2, 1));
    float d = box(p + vec3(0, 1, 0), vec3(0.2, 1, 0.2));
    
    vec2 s = vec2(a, 1.0);
    vec2 t = vec2(min(b, min(c, d)), 2.0);
    
    return s.x < t.x ? s : t;
}

void opIFS(inout vec4 q) {
    for(int i = 0; i < 9; i++) {
        q.xyz = abs(q.xyz) - vec3(0.900,1.393,0.594);
        q.xz *= rot(0.628 + float(i)*0.932);
        q.xy *= rot(0.644);
        
        q *= 1.2;
    }
}

vec2 de(vec3 p) {
    vec4 q = vec4(p, 1);
    
    opIFS(q);
    
    return shape(q.xyz)/vec2(q.w, 1);
}

vec3 form(vec2 p, sampler2D s) {
    for(int i = 0; i < 3; i++) {
        p = abs(p)/clamp(dot(p, p), 0.5, 1.0) - vec2(0.1, 0.3);
        p *= rot(0.33);
    }
    
    return texture(s, p).rgb;
}

vec3 mat(vec3 p, vec3 n, sampler2D s) {
    vec3 m = pow(abs(n), vec3(10.0));
    m /= dot(vec3(1), m);
    
    vec3 x = form(p.yz, s);
    vec3 y = form(p.xz, s);
    vec3 z = form(p.xy, s);
    
    return (m.x*x*x + m.y*y*y + m.z*z*z);
}

vec3 bump(vec3 p, vec3 n, sampler2D s, float bf) {
    vec2 h = vec2(0.01, 0);
    vec3 g = mat3(
        mat(p - h.xyy, n, s),
        mat(p - h.yxy, n, s),
        mat(p - h.yyx, n, s)
    )*vec3(0.299, 0.548, 0.114);
    
    g -= dot(mat(p, n, s), vec3(0.299, 0.548, 0.114));
    g -= n*dot(g, n);
    
    return normalize(n + bf*g);
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    vec2 uv = (gl_FragCoord.xy - 0.5*iResolution.xy)/iResolution.y;
    vec2 mo = 5.0*iMouse.xy/iResolution.xy;
    
    vec3 col = vec3(0);
    
    float a = 6.8;
    float at = iTime*0.1;
    
    vec3 ro = vec3(a*sin(at + mo.x), 2.0*sin(at*2.0 + mo.y), -a*cos(at + mo.x));
    vec3 ww = normalize(vec3(0)-ro);
    vec3 uu = cross(vec3(0, 1, 0), ww);
    vec3 vv = cross(ww, uu);
    vec3 rd = normalize(mat3(uu, vv, ww)*vec3(uv, 1));
    
    float t = 0.0, m = -1.0, mx = 10.0;
    for(int i = 0; i < 200; i++) {
        vec2 d = de(ro + rd*t);
        if(d.x < 0.001 || t >= mx) break;
        t += d.x*0.5;
        m = d.y;
    }
    
    if(t < mx) {
        vec3 p = ro + rd*t;
        vec2 h = vec2(0.001, 0.0);
        vec3 n = normalize(vec3(
            de(p + h.xyy).x - de(p - h.xyy).x,
            de(p + h.yxy).x - de(p - h.yxy).x,
            de(p + h.yyx).x - de(p - h.yyx).x
        ));
        
        vec3 ld = normalize(p);
        
        vec3 alb = vec3(1);
        vec4 q = vec4(p, 1);
        
        opIFS(q);
        if(m == 1.0) {
			alb = vec3(0.075,0.401,1.000);
            n = bump(p, n, iChannel0, 0.2);
        } else if(m == 2.0) {
            alb = vec3(1.000,0.550,0.015);
            n = bump(p, n, iChannel0, 0.15);
        }
        
        float oat = t/50.0;
        float occ = exp2(-pow(max(0.0, 1.0 - de(p + n*oat).x/oat), 2.0));
        float dif = max(0.0, dot(ld, n));
        
        float sp = pow(max(0.0, dot(reflect(-ld, n), -rd)), 32.0);
        
        col = 0.75*occ*(alb*(0.25 + dif) + 2.0*vec3(0.6, 0.7, 1.0)*sp);
    }
    
    fragColor = vec4(pow(col, vec3(0.4545)), 1);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

